<?php include '_partials/header.php'; ?>

<table class="table table-striped table-hover">
	<thead>
		<tr>
			<td>Name</td>
			<td>Kills</td>
			<td>Deaths</td>
			<td>K/D</td>
			<td>Headshots</td>
			<td>HS Ratio</td>
		</tr>
	</thead>
	<tbody>
	<?php foreach( $users as $u ) {
			$nicks = explode(';', $u->nicks);
			$nicks = array_map('htmlentities', $nicks);;
			if($u->kills == 0) {
				$kd = 0;
			} elseif($u->deaths != 0) {
				$kd = round($u->kills / $u->deaths, 2);
			} else {
				$kd = "Infinty";
			}
			$hsratio = ( $u->kills != 0) ? round($u->headshots / $u->kills * 100, 2) : 0;
			echo "<tr><td>{$nicks[0]}</td><td>{$u->kills}</td><td>{$u->deaths}</td><td>{$kd}</td><td>{$u->headshots}</td><td>{$hsratio} %</td></tr>";
	} ?>

	<script id="user_list_template" type="text/x-handlebars-template">
		{{#each this}}
		<tr>
			<td>{{firstName this}}</td>
			<td>{{kills}}</td>
			<td>{{deaths}}</td>
			<td>{{kd this}}</td>
			<td>{{headshots}}</td>
			<td>{{hsr this}} %</td>
		</tr>
		{{/each}}
	</script>
	
	</tbody>
</table>

<?php include '_partials/footer.php'; ?>