<?php

$mod->registerEvent("playerKill", "killfunrow_main");
$mod->registerEvent("playerDeath", "killfunrow_die");
$mod->registerEvent("playerSelfkill", "killfunrow_Selfdie");
$mod->registerEvent("everyTime", "killfunrow_reset");

$mod->registerCommand("streak1", false, "killfunrow_speed");
$mod->registerCommand("streak2", false, "killfunrow_gravity");

array_map("killfunrow_playerInit", array_keys($players));


$mod->setDefaultCV("killfunrow", "enabled", 0);
$mod->setDefaultCV("killfunrow", "kills", 15);
$mod->setDefaultCV("killfunrow", "time", 45);
$mod->setDefaultCV("killfunrow", "speed", 350);
$mod->setDefaultCV("killfunrow", "gravity", 5);

function killfunrow_main($parameters) {
	global $players;
	global $mod;
	global $liner;
		//Ist [killfunrow]enabled = 1
	if (!$mod->getCV("killfunrow", "enabled")) {
		return false;
	}
	
    list($killer_guid, $victim_guid, $weapon) = $parameters;
	//anzeigen wieviele kills man schon hat.
	++$liner['players'][$killer_guid]['killCounter'];
	if($liner['players'][$killer_guid]['killCounter'] == $mod->getCV("killfunrow", "kills")){
		$players[$killer_guid]->say('^1!!! ^220 KILLS ^1!!! ^7Change ^1speed ^7(^1!streak1^7) or ^1gravity ^7(^1!streak2^7).');
		$liner['players'][$killer_guid]['special'] = 1;
	}
}

function killfunrow_playerInit($guid) {
	global $liner;
    $liner['players'][$guid]['killCounter'] = 0;
	$liner['players'][$guid]['special'] = 0;
	$liner['change']['gravity'] = 0;
	$liner['change']['speed'] = 0;
}

function killfunrow_die($parameters) {
	global $players;
	global $mod;
	global $liner;
    list($killer_guid, $victim_guid, $weapon) = $parameters;

    $liner['players'][$killer_guid]['killCounter'] = 0;
}

function killfunrow_Selfdie($guid) {
	global $players;
	global $mod;
	global $liner;
    $liner['players'][$guid]['killCounter'] = 0;
}

function killfunrow_speed($guid) {
	global $players;
	global $mod;
	global $liner;

	if($liner['players'][$guid]['special'] == 1){
		$GLOBALS['rcon']->rcon('set g_speed '.$mod->getCV("killfunrow", "speed"));
		
		$liner['players'][$guid]['special'] = 0;
		$mod->rconSay('^2'.$players[$guid]->getName().' ^1increased the speed for ^7'.$mod->getCV("killfunrow", "time").' ^1seconds^7.');
		
		$liner['change']['speed'] = time();
	}else{
		$players[$guid]->say('^7You need ^120 ^7Kills in row to activate this streak^1!');
	}

}

function killfunrow_gravity($guid) {
	global $players;
	global $mod;
	global $liner;

	if( $liner['players'][$guid]['special'] == 1){
		$GLOBALS['rcon']->rcon('set g_gravity '.$mod->getCV("killfunrow", "gravity"));
		
		$liner['players'][$guid]['special'] = 0;
		$mod->rconSay('^2'.$players[$guid]->getName().' ^1increased the ^7gravity ^1for ^7'.$mod->getCV("killfunrow", "time").' ^1seconds^7.');
		
		$liner['change']['gravity'] = time();
	}else{
		$players[$guid]->say('^7You need ^120 ^7Kills in row to activate this streak^1!');
	}

}

function killfunrow_reset(){
	global $mod;
	global $liner;
	
	if( $liner['change']['gravity'] != 0 && $liner['change']['gravity'] < time()-$mod->getCV("killfunrow", "time")){
		$GLOBALS['rcon']->rcon('set g_gravity 800');
		$liner['change']['gravity'] = 0;
		$mod->rconSay('^1Gravity ^7set to normal value');
	}

	if( $liner['change']['speed'] != 0 && $liner['change']['speed'] < time()-$mod->getCV("killfunrow", "time")){
		$GLOBALS['rcon']->rcon('set g_speed 190');
		$liner['change']['speed'] = 0;
		$mod->rconSay('^1Speed ^7set to normal value');
	}
	
}

?>