<?php

error_reporting(E_ALL);

$language = "en";
if (isset($_GET["lang"]) && in_array($_GET["lang"], array("en", "de"))) $language = $_GET["lang"];

$lang["de"]["title"] = "admins.cfg-Generator";
$lang["de"]["heading"] = "admins.cfg-Generator";
$lang["de"]["changelang"] = "Show this page in ENGLISH";
$lang["de"]["overview"] = "bersicht";
$lang["de"]["versionwarning"] = "<b><u>Achtung:</u></b><br />Dieser Generator ist NUR fr <b>Versionen ab 0.7</b> geeignet!";
$lang["de"]["otherlang"] = "en";
$lang["de"]["currentadmins"] = "Aktuelle Admins";
$lang["de"]["group"] = "Gruppe";
$lang["de"]["protected"] = "Geschtzt";
$lang["de"]["nicks"] = "Nicknamen";
$lang["de"]["yes"] = "Ja";
$lang["de"]["no"] = "Nein";
$lang["de"]["generate"] = "admins.cfg generieren";
$lang["de"]["edit"] = "Bearbeiten";
$lang["de"]["del"] = "Lschen";
$lang["de"]["addadmin"] = "Admin hinzufgen/bearbeiten";
$lang["de"]["save"] = "Speichern";
$lang["de"]["onename"] = "Ein Gruppe pro Zeile";
$lang["de"]["onegroup"] = "Ein Nick pro Zeile";
$lang["de"]["groups"] = "Gruppen";
$lang["de"]["error"] = "Fehler";
$lang["de"]["canceledit"] = "Bearbeiten abbrechen";
$lang["de"]["load"] = "Laden";
$lang["de"]["loadfile"] = "admins.cfg einlesen";
$lang["de"]["override"] = "berschreibe aktuelle Admins";
$lang["de"]["err_guid"] = "Fehlerhafte GUID";
$lang["de"]["err_group"] = "Fehlerhafte Gruppe";
$lang["de"]["err_protect"] = "Bitte Wert bei 'Protected' whlen";
$lang["de"]["err_nick"] = "Bitte keine Kommas (,) und doppelten Anfhrungszeichen (&quot;) bei Nicknames verwenden";
$lang["de"]["download"] = "Herunterladen &amp; speichern";

$lang["en"]["title"] = "admins.cfg-Generator";
$lang["en"]["heading"] = "admins.cfg-Generator";
$lang["en"]["versionwarning"] = "<b><u>Attention:</u></b><br />This generator can only be used for <b>versions >= 0.7</b>!";
$lang["en"]["changelang"] = "Zeige diese Seite in DEUTSCH";
$lang["en"]["overview"] = "Overview";
$lang["en"]["otherlang"] = "de";
$lang["en"]["currentadmins"] = "Current admins";
$lang["en"]["group"] = "Group";
$lang["en"]["protected"] = "Protected";
$lang["en"]["nicks"] = "Nicknames";
$lang["en"]["yes"] = "Yes";
$lang["en"]["no"] = "No";
$lang["en"]["generate"] = "Generate admins.cfg";
$lang["en"]["edit"] = "Edit";
$lang["en"]["del"] = "Delete";
$lang["en"]["addadmin"] = "Add/Edit admin";
$lang["en"]["save"] = "Save";
$lang["en"]["onename"] = "One nick per line";
$lang["en"]["onegroup"] = "One group per line";
$lang["en"]["groups"] = "Groups";
$lang["en"]["error"] = "Error";
$lang["en"]["canceledit"] = "Cancel edit";
$lang["en"]["load"] = "Load";
$lang["en"]["loadfile"] = "Load admins.cfg";
$lang["en"]["override"] = "Override current admins";
$lang["en"]["err_guid"] = "Wrong GUID";
$lang["en"]["err_group"] = "Wrong Group";
$lang["en"]["err_protect"] = "Please choose a value at 'Protected'";
$lang["en"]["err_nick"] = "Please do not use commas (,) or quotes (&quot;) in nicknames";
$lang["en"]["download"] = "Download &amp; save";


session_start();

if (!isset($_SESSION["admins"])) {
	$_SESSION["admins"] = array();
}

if (!isset($_SESSION["groups"])) {
	$_SESSION["groups"] = array("master", "admin", "member", "user");
}

if (isset($_GET["del"]) && is_numeric($_GET["del"]) && array_key_exists($_GET["del"], $_SESSION["admins"])) {
	unset($_SESSION["admins"][$_GET["del"]]);
}

if (isset($_POST["groups"]) && !empty($_POST["groupssubmit"])) {
    $groups = trim($_POST["groups"]);
    if (preg_match('~^[a-z0-9_-]+((\r|\n|\r\n)[a-z0-9_-]+)*$~i', $groups)) {
        $_SESSION["groups"] = explode("\n", $groups);
        $_SESSION["groups"] = array_map("trim", $_SESSION["groups"]);
    }
}

if (isset($_POST["upload"]) && $_FILES["file"]["size"] > 0 && $_FILES["file"]["size"] < 50 * 1024) {
    if (isset($_POST["override"])) $_SESSION["admins"] = array();
    $upload = parse_ini_file($_FILES["file"]["tmp_name"], true);
    foreach ($upload as $guid => $admin) {
        if (!preg_match('#^(([0-9]{7-13})|([a-f0-9]{32}))$#', $guid)) {
            continue;
        }
        if (!isset($admin["group"])) {
            continue;
        }
        if (!isset($admin["names"])) {
            if (isset($admin["name"])) {
                $admin["names"] = explode(",", $admin["name"]);
            }
            else {
                $admin["names"] = "";
            }
        }
        else {
            $admin["names"] = explode(",", $admin["names"]);
        }
        if (!isset($admin["protected"])) {
            $admin["protected"] = false;
        }
        else {
            $admin["protected"] = (bool)(int)$admin["protected"];
        }
        $_SESSION["admins"][] = array("guid"=>$guid) + $admin;
    }
}

if (isset($_POST["submit"]) && !is_numeric($_GET["edit"])) {
	$edit = false;

	$error = array();
	if (!isset($_POST["guid"]) || !preg_match('#^(([0-9]{7,13})|([a-f0-9]{32})|([a-f0-9]{16}))$#', $_POST["guid"])) {
		$error[] = $lang[$language]["err_guid"];
	}
	if (!isset($_POST["group"]) || !in_array($_POST["group"], $_SESSION["groups"])) {
		$error[] = $lang[$language]["err_group"];
	}
	if (!isset($_POST["protected"])) {
		$error[] = $lang[$language]["err_protect"];
	}
	if (!isset($_POST["nicknames"]) || strpos($_POST["nicknames"], ",") !== false || strpos($_POST["nicknames"], "\"") !== false) {
		$error[] = $lang[$language]["err_nick"];
	}

	if (empty($error)) {
		$_POST["nicknames"] = stripslashes($_POST["nicknames"]);

		$_SESSION["admins"][] = array(
			"guid" => $_POST["guid"],
			"group" => $_POST["group"],
			"protected" => (bool)(int)$_POST["protected"],
			"names" => array_map("trim",  explode("\n", stripslashes($_POST["nicknames"])))
		);
		$edit = false;
		$guid = "";
		$group = "user";
		$protected = 0;
		$nicks = array();
	}
	else {
		$guid = htmlspecialchars(stripslashes($_POST["guid"]));
		$group = htmlspecialchars(stripslashes($_POST["group"]));
		$protected = (bool)(int)$_POST["protected"];
		$nicks = array_map("trim",  explode("\n", stripslashes($_POST["nicknames"])));
	}
}
elseif (isset($_GET["edit"]) && is_numeric($_GET["edit"]) && array_key_exists($_GET["edit"], $_SESSION["admins"])) {
	$edit = $_GET["edit"];
	if (isset($_POST["submit"])) {
		$error = array();
		if (!isset($_POST["guid"]) || !preg_match('#^(([0-9]{7-13})|([a-f0-9]{32}))$#', $_POST["guid"])) {
			$error[] = $lang[$language]["err_guid"];
		}
    	if (!isset($_POST["group"]) || !in_array($_POST["group"], $_SESSION["groups"])) {
    		$error[] = $lang[$language]["err_group"];
    	}
		if (!isset($_POST["protected"])) {
			$error[] = $lang[$language]["err_protect"];
		}
		if (!isset($_POST["nicknames"]) || strpos($_POST["nicknames"], ",") !== false || strpos($_POST["nicknames"], "\"") !== false) {
			$error[] = $lang[$language]["err_nick"];
		}
		if (empty($error)) {
			$_SESSION["admins"][$_GET["edit"]] = array(
				"guid" => $_POST["guid"],
				"group" => $_POST["group"],
				"protected" => (bool)(int)$_POST["protected"],
				"names" => array_map("trim",  explode("\n", stripslashes($_POST["nicknames"])))
			);
			$edit = false;
			$guid = "";
			$group = "user";
			$protected = 0;
			$nicks = array();
		}
		else {
			$guid = htmlspecialchars(stripslashes($_POST["guid"]));
			$group = htmlspecialchars(stripslashes($_POST["group"]));
			$protected = (bool)(int)$_POST["protected"];
			$nicks = array_map("trim",  explode("\n", stripslashes($_POST["nicknames"])));
		}
	}
	else {
		$guid = $_SESSION["admins"][$_GET["edit"]]["guid"];
		$group = $_SESSION["admins"][$_GET["edit"]]["group"];
		$protected = $_SESSION["admins"][$_GET["edit"]]["protected"];
		$nicks = $_SESSION["admins"][$_GET["edit"]]["names"];
	}
}
else {
	$edit = false;
	$guid = "";
	$group = "user";
	$protected = 0;
	$nicks = array();
}

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-2" />
<title><?php echo $lang[$language]["title"] ?></title>
<link href="style.css" type="text/css" rel="stylesheet" />
</head>
<body>
<img src="http://images.gw-2.de/images/901e2d94448ee5576dd3.png" alt="Manu-Admin-Mod" style="margin: auto; display:block" />
<h1><?php echo $lang[$language]["heading"] ?></h1>

<p><a href="?lang=<?php echo $lang[$language]["otherlang"]; ?>"><?php echo $lang[$language]["changelang"]; ?></a></p>
<p><img src='warning.png' alt='' class="warning" /><?php echo $lang[$language]["versionwarning"]; ?></p>

<?php

if (isset($_POST["generate"])) {
	echo "<p><b>admins.cfg:</b><br /><textarea cols='117' rows='20' wrap='off'>";
    $file = "";
	$file .= "; This file will be overwritten by the mod automatically
; Do not make any comments inhere
; Use the generator to generate a valid file: http://manuadminmod.de/config/admin.php\n\n";
	foreach ($_SESSION["admins"] as $admin) {
		$file .= "[$admin[guid]]\n";
		$file .= "group = \"$admin[group]\"\n";
		$file .= "protected = " . (int) $admin["protected"] . "\n";
		$file .= "names = \"" . implode(",", $admin["names"]) . "\"\n\n";
	}

	echo htmlentities($file) . "</textarea></p>\n";
	echo "<form action='download.php' method='post'>\n";
	echo "<p><input type='submit' value='".$lang[$language]["download"]."' /></p>\n";
	echo "<input type='hidden' value='".base64_encode($file)."' name='data' />\n";
	echo "<input type='hidden' name='filename' value='admins.cfg' />\n";
	echo "</form>\n";
}

?>

<fieldset>
<legend><?php echo $lang[$language]["currentadmins"] ?></legend>
<table cellspacing="1">
<tr><th>GUID</th><th><?php echo $lang[$language]["group"] ?></th><th><?php echo $lang[$language]["protected"] ?></th><th><?php echo $lang[$language]["nicks"] ?></th><th></th><th></th></tr>
<?php

$yesno = array($lang[$language]["no"], $lang[$language]["yes"]);

foreach ($_SESSION["admins"] as $adminid => $admin) {
	echo "<tr>\n";
	echo "<td><i>" . $admin["guid"] . "</i></td>";
	echo "<td>" . $admin["group"] . "</td>";
	echo "<td>" . $yesno[(int) $admin["protected"]] . "</td>";
	echo "<td>" . htmlspecialchars(implode(",", $admin["names"])) . "</td>";
	echo "<td><a href='?edit=$adminid&amp;lang=$language'>".$lang[$language]["edit"]."</a></td>";
	echo "<td><a href='?del=$adminid&amp;lang=$language'>".$lang[$language]["del"]."</a></td>";
	echo "</tr>\n";
}

?>
</table>

<form action="admin.php?lang=<?php echo $language ?>" method="post">
<p><input type="submit" name="generate" value="<?php echo $lang[$language]["generate"] ?>" /></p>
</form>
</fieldset>

<fieldset>
<legend><?php echo $lang[$language]["addadmin"] ?></legend>

<?php
if (!empty($error)) {
	echo "<p class='error'><b>".$lang[$language]["error"].":</b><br />" . implode("<br />\n", $error) . "</p>\n";
}
?>

<form action="admin.php?edit=<?php echo $edit ?>&amp;lang=<?php echo $language ?>" method="post">
<table cellspacing="1">
<tr>
<td><b>GUID: </b></td>
<td><input type="text" name="guid" value="<?php echo $guid ?>" maxlength="32" size="34" /> </td>
<td><!--<input type="radio" name="guidtype" value="cod2" /> <?php echo $lang[$language]["guidtype_cod2"] ?><br />
<input type="radio" name="guidtype" value="cod4" /> <?php echo $lang[$language]["guidtype_cod4"] ?><br />
<input type="radio" name="guidtype" value="cod5" /> <?php echo $lang[$language]["guidtype_cod5"] ?>--></td>
</tr>
<tr>
<td><b><?php echo $lang[$language]["group"] ?>: </b></td>
<td colspan="2"><select name='group'><?php
foreach ($_SESSION["groups"] as $value) {
    if ($group == $value) {
        echo "<option value='$value' selected='selected'>$value</option>";
    }
    else {
        echo "<option value='$value'>$value</option>";
    }
}
?></select></td>
</tr>
<tr>
<td><b><?php echo $lang[$language]["protected"] ?>: </b></td>
<td colspan="2"><input type="radio" name="protected" value="1" <?php if($protected)echo "checked='checked'" ?> /> <?php echo $lang[$language]["yes"] ?> <input type="radio" name="protected" value="0" <?php if(!$protected)echo "checked='checked'" ?> /> <?php echo $lang[$language]["no"] ?></td>
</tr>
<tr>
<td><b><?php echo $lang[$language]["nicks"] ?>:</b></td>
<td colspan="2"><textarea name="nicknames" rows="4" cols="30"><?php echo htmlspecialchars(implode("\n", $nicks)) ?></textarea><br />
<small><?php echo $lang[$language]["onename"] ?></small></td>
</tr>
</table>
<p><input type="submit" name="submit" value="<?php echo $lang[$language]["save"] ?>" /><?php if ($edit !== false) echo " <a href='admin.php?lang=$language'>".$lang[$language]["canceledit"]."</a>" ?></p>
</form>
</fieldset>
<fieldset>
<legend><?php echo $lang[$language]["loadfile"]; ?></legend>
<form action="" method="post" enctype="multipart/form-data">
<p><input type="file" name="file" size="50" /><input type="submit" value="<?php echo $lang[$language]["load"]; ?>" name="upload" /> <input type="checkbox" name="override" id="override" checked="checked" /> <label for="override"><?php echo $lang[$language]["override"]; ?></label></p>
</form>
</fieldset>
<fieldset>
<legend><?php echo $lang[$language]["groups"] ?></legend>
<form action="admin.php?lang=<?php echo $language ?>" method="post">
<textarea cols="30" rows="5" name="groups"><?php echo implode("\n", $_SESSION["groups"]); ?></textarea><br />
<small><?php echo $lang[$language]["onegroup"] ?></small>
<p><input type="submit" name='groupssubmit' value="<?php echo $lang[$language]["save"] ?>" /></p>
</form>
</fieldset>
<p style='text-align: center'>Copyright by <a href='http://manuadminmod.de/'>ManuAdminMod.de</a></p>
</body>
</html>