<?php
/**
 * Anti Empty GUID Plugin
 * This plugin will kick player with empty guid.
 *
 * Commands: none
 *
 * Config (example)
 *      [antiemptyguid]
 *      enabled = 1
 *      mode = "kick"
 *      kickreason = "Empty GUID is not valid!"
 *
 * Config var "mode" allows "kick", "tempban" and "ban".
 *
 * @author silva202
 * @license Creative Commons BY-NC-SA 3.0 (http://www.creativecommons.org/licenses/by-nc-sa/3.0/)
 * @version 1.0
 */

$antiEmptyGuid = new AntiEmptyGuid();

// events and commands
$mod->registerEvent("playerJoined", "playerJoined", $antiEmptyGuid);

// default CVars
$mod->setDefaultCV("antiemptyguid", "enabled", 1);
$mod->setDefaultCV("antiemptyguid", "mode", "kick");
$mod->setDefaultCV("antiemptyguid", "kickreason", "Empty GUID is not valid!");

class AntiEmptyGuid {

	public function playerJoined ($guid)
	{
		global $mod;
		global $players;
		
		if (!$mod->getCV("antiemptyguid", "enabled"))
		{
			return;
		}
		
		if (trim($guid) == "")
		{
			switch ($mod->getCV("antiemptyguid", "mode"))
			{
				case "tempban":
					$players[$guid]->tempBan($mod->getCV("antiemptyguid", "kickreason"));
					break;
				case "kick":
					$players[$guid]->kick($mod->getCV("antiemptyguid", "kickreason"));
					break;
				case "ban":
					$players[$guid]->ban($mod->getCV("antiemptyguid", "kickreason"));
					break;
			}
		}
	}
}
