<?php

$antiMultiGuid = new antiMultiGuid();

$mod->registerEvent("playerJoined", "playerJoined", $antiMultiGuid);

class antiMultiGuid
{
	private $internalPlayer = array(); // keys per entry: pid, score, ping, guid, name, lastmsg, ip, port, qport, rate
	
	public function __construct()
	{
		$this->refreshInternalPlayerArray();
	}
	
	public function refreshInternalPlayerArray()
	{
		global $mod;
		$this->internalPlayer = $mod->rconPlayerList();
	}
	
	public function playerJoined($guid)
	{
		global $mod, $logging;
		
		$oldPlayer = $this->getInternalPlayer($guid);
		$this->refreshInternalPlayerArray();
		if ($oldPlayer !== false)
		{
			$logging->write(MOD_NOTICE, "New player joined with already assigned guid, kick him!");
			$newPlayer = $this->getInternalPlayer($guid, $oldPlayer["pid"]);
			$mod->rconRcon("clientkick " . $newPlayer["pid"]);
		}
	}
	
	private function getInternalPlayer($guid, $notPID = -1)
	{
		foreach ($this->internalPlayer as $player)
		{
			if ($player["guid"] == $guid && $player["pid"] != $notPID)
			{
				return $player;
			}
		}
		return false;
	}
	
}
