<?php
$geoip	=	new	Geoip_class();

class Geoip_class	{
	private	$mod;
	private	$logging;
	private	$geoip_database;
	private $database = false;
	private $dir;

	function __construct()	{
		$this->mod		= $GLOBALS['mod'];
		$this->logging	= $GLOBALS['logging'];

		$this->dir = $this->mod->getConfigDir()	.	"/plugins/geoip/";
		$this->prepare();
	}

	private function prepare() {
		$check = false;
		if(file_exists($this->dir . "GeoIP.dat")) {
			$this->mod->Rconrcon("Country");
			include_once($this->dir . "geoip.inc");
			$this->geoip_database	= geoip_open($this->dir . "GeoIP.dat", GEOIP_STANDARD);
			$this->database = "Country";
			$this->logging->write(MOD_NOTICE, "GEOIP: GEOIPCountry Database succesfully reloaded");
		}
		if(file_exists($this->dir . "GeoLiteCity.dat")) {
			$this->mod->Rconrcon("City");
			require_once($this->dir . "geoipcity.inc");
			$this->geoip_database = geoip_open($this->dir ."GeoLiteCity.dat", GEOIP_STANDARD);
			$this->database = "City";
			$this->logging->write(MOD_NOTICE, "GEOIP: GEOIPCity Database succesfully reloaded");
		}

		if($this->database == false) {
			$this->logging->write(MOD_WARNING, "GEOIP: Can't find Database Please Download it!");
			return false;
		}
	}


	public function getCountryCode($ip) {
		if($this->database == "Country") {
			return geoip_country_code_by_addr($this->geoip_database, $ip);
		}

		if($this->database == "City") {
			$array = geoip_record_by_addr($this->geoip_database, $ip);
			return $array->country_code;
		}
	}

	public function getCountryName($ip) {
		if($this->database == "Country") {
			return geoip_country_name_by_addr($this->geoip_database , $ip);
		}

		if($this->database == "City") {
			$array = geoip_record_by_addr($this->geoip_database, $ip);
			return $array->country_name;
		}
	}
	public function getCity($ip) {
		if($this->database != "City") return;
		$array = geoip_record_by_addr($this->geoip_database, $ip);
		return $array->city;
	}

	public function getRegionName($ip) {
		global $GEOIP_REGION_NAME;
		if($this->database != "City") return;
		$array = geoip_record_by_addr($this->geoip_database, $ip);
		return $GEOIP_REGION_NAME[$array->country_code][$array->region];
	}

	public function getContinent($ip) {
		if($this->database != "City") return;
		$array = geoip_record_by_addr($this->geoip_database, $ip);
		return $array->continent_code;
	}
}

$mod->setDefaultCV("geoip",	"enabled",	1);
$mod->setDefaultCV("geoip",	"message",	"^1My	Name	is:	^2<PLAYERNAME>^1.And	I	am	from	^2<CONTINENT>	^1->	^2<COUNTRY>");
$mod->setDefaultCV("geoip",	"adminmessage",	"Name	<PLAYERNAME>	-	From	||<CONTINENT>	||<COUNTRY>	||<REGION> ||<CITY>");
$mod->setDefaultCV("geoip_welcomemessages", "enabled", 0);
$mod->setDefaultCV("geoip_welcomemessages", "whisper", 0);

$mod->registerCommand("geo",	false	,	"command_geo"	);
$mod->registerCommand("geoip",	'~^geoip \S.*$~i' , "command_geoip"	);
$mod->registerEvent("playerJoined", "geoip_welcomemessage");


function command_geo($guid) {
	global	$mod;
	global	$players;
	global  $geoip;

	if	($mod->getCV("geoip", "enabled") == 0)	return false;

	$status	= $mod->rconPlayerList();
	foreach	($status as	$line) {
		if	($line["pid"] == $players[$guid]->getPid() || $line["guid"]	==	$players[$guid]) {
			$ip	= $line["ip"];
			break;
		}
	}

		$search	=	array(
					"<PLAYERNAME>",
					"<COUNTRY>",
					"<COUNTRY_CODE>",
					"<CITY>",
					"<CONTINENT>",
					"<REGION>",
					);

	$replace	=	array(
					$players[$guid]->getName(),
					$geoip->getCountryName($ip),
					$geoip->getCountryCode($ip),
					$geoip->getCity($ip),
					$geoip->getContinent($ip),
					$geoip->getRegionName($ip),
					);

	str_replace($search , $replace , $mod->GetCV("geoip", "message"));

	$mod->RconSay(str_replace($search , $replace , $mod->GetCV("geoip", "message")));
}

function command_geoip($guid, $parameter) {
	global	$mod;
	global	$players;
	global	$geoip;

	if	(!$mod->getCV("geoip",	"enabled")) return	false;

	$parameter = implode(" ", $parameter);

	$player_guid = $mod->findPlayerGuid($parameter);
	if	(!$player_guid) {
			$players[$guid]->say($mod->getLngString("playerNotFound",	array("<SEARCH>"),	array($parameter)));
			return	false;
	}

	$status	=	$mod->rconPlayerList();
	foreach	($status as $line) {
		if	($line["pid"] == $players[$player_guid]->getPid() ||	$line["guid"] == $players[$player_guid]->getGuid()) {
			$ip	= $line["ip"];
			break;
		}
	}

		$search	=	array(
					"<PLAYERNAME>",
					"<COUNTRY>",
					"<COUNTRY_CODE>",
					"<CITY>",
					"<CONTINENT>",
					"<REGION>",
					);

	$replace	=	array(
					$players[$player_guid]->getName(),
					$geoip->getCountryName($ip),
					$geoip->getCountryCode($ip),
					$geoip->getCity($ip),
					$geoip->getContinent($ip),
					$geoip->getRegionName($ip),
					);

	$players[$guid]->say(str_replace($search , $replace , $mod->GetCV("geoip", "adminmessage")));
}

//Hauptfunktion die aufgerufen wird, wenn ein Spieler joint; Argument: GUID des neuen Spielers
function geoip_welcomemessage($guid) {
	global $players;
	global $mod;
	global $geoip;

	//Ist [welcomemessages]enabled = 1
	if (!$mod->getCV("welcomemessages", "enabled")) return false;


	$status	= $mod->rconPlayerList();
	foreach	($status as	$line) {
		if	($line["pid"] == $players[$guid]->getPid() || $line["guid"]	==	$players[$guid]) {
			$ip	= $line["ip"];
			break;
		}
	}

	//Gruppe des neuen Spielers abrufen
	$group = $players[$guid]->getGroup();

	//Existiert eine Welcomemessage fr diese Gruppe?
	if ($mod->existsCV("welcomemessages", $group)) {

		//Fhre die replaces in der Message durch
		$search = array(
			"<PLAYER_NAME>",
			"<GROUP_NAME>",
			"<COUNTRY>",
			"<COUNTRY_CODE>",
			"<CITY>",
			"<CONTINENT>",
			"<REGION>",
		);

		$replace = array(
			$players[$guid]->getName(),
			$mod->getLongGroupName($group),
			$geoip->getCountryName($ip),
			$geoip->getCountryCode($ip),
			$geoip->getCity($ip),
			$geoip->getContinent($ip),
			$geoip->getRegionName($ip),
		);

		//Sende die Message
		if ($mod->getCV("welcomemessages", "whisper")) {
			$players[$guid]->say(str_replace($search, $replace, $mod->getCV("welcomemessages", $group)));
		}
		else {
			$mod->rconSay(str_replace($search, $replace, $mod->getCV("welcomemessages", $group)));
		}
	}
}
?>

