<?php

// read banned_ips from config/plugins/banned_ips.lst
// and write to banned_ips array
$banned_ips = @file($mod->getConfigDir() . "/plugins/banned_ips.lst", FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
if (!$banned_ips) $banned_ips = array(); // if false create empty array

// register command to ban an ip
$mod->registerCommand("banip", false, "banip_add_ip");

// function to ban an ip
function banip_add_ip($guid, $parameters) {
    global $players;
	global $mod;
	global $banned_ips;
	
	$player_to_ban = implode(" ", $parameters);
	$player_to_ban_guid = $mod->findPlayerGuid($player_to_ban);
	
	if (!$player_to_ban_guid) {
		$players[$guid]->say($mod->getLngString("playerNotFound", array("<SEARCH>"), array($player_to_ban)));
		return false;
	}
	
	$rconPlayerList = $mod->rconPlayerList();
	foreach($rconPlayerList as $rconPlayer) {
		if ($rconPlayer["guid"] == $player_to_ban_guid) {
			// add ip to banned_ips array
			$banned_ips[] = $rconPlayer["ip"];
			// write ip to config/plugins/banned_ips.lst
			$fp = fopen($mod->getConfigDir() . "/plugins/banned_ips.lst", "a");
			fwrite($fp, $rconPlayer["ip"] . "\r\n");
			fclose($fp);
			// ban player
			$players[$player_to_ban_guid]->ban();
		}
	}
}

// register trigger to check joined player
$mod->registerEvent("playerJoined", "banip_check_joined_player");

// function to check joined player
function banip_check_joined_player($guid) {
    global $players;
	global $mod;
	global $banned_ips;
	
	$rconPlayerList = $mod->rconPlayerList();
	foreach($rconPlayerList as $rconPlayer) {
		if ($rconPlayer["guid"] == $guid && in_array($rconPlayer["ip"], $banned_ips)) {
			// ban player
			$players[$guid]->ban();
		}
	}
}

?>
