<?php
/**
 * Plugin for ManuAdminMod
 * This plugin will send the serverrules vie private message to the player.
 * It can send the rules automatically, after a player joined.
 *
 * @author: silva202
 * @version: 1.0.1
 */

$mod->setDefaultCV("rules", "enabled", 1);
$mod->setDefaultCV("rules", "afterjoin", 0);

$mod->registerEvent("parseConfig", "rules_read");
$mod->registerEvent("playerJoined", "rules_afterjoin");
$mod->registerCommand("rules", false, "rules_send");

$rules = array();


/**
 * Read the rules from file
 */
function rules_read() {
    global $rules, $mod;
	$rules = file($mod->getConfigDir() . "/plugins/rules.lst", FILE_IGNORE_NEW_LINES);
    if (!$rules) $rules = array();
}

rules_read(); // initial read


/**
 * Send rules after a player joined.
 * (wrapper function, will call rules_send())
 */
function rules_afterjoin($guid) {
	global $mod;
	
	if ($mod->getCV("rules", "afterjoin")) {
		rules_send($guid);
	}
}


/**
 * Send rules in private messages to the player.
 */
function rules_send($guid) {
	global $rules, $mod, $players;
	
	if (!$mod->getCV("rules", "enabled")) {
		return;
	}
	
	foreach ($rules as $rule) {
		$players[$guid]->say($rule);
	}
}

?>
